/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package proc.text;

import javax.swing.JTextArea;

import java.util.Vector;

public class Out {
    private static JTextArea infoComponent;
    private static JTextArea erreurComponent;
    private static Vector<String> bufferInfo = new Vector<String>();
    private static Vector<String> bufferErreurs = new Vector<String>();
    private static int tailleBuffer = 1000;

    private final static Object lockInfo = new Object();
    public static void printInfo(String text) {
        synchronized (lockInfo) { // Différents Threads essaieront d'écrire en même temps
            bufferInfo.addElement(text);
            while (bufferInfo.size() > tailleBuffer) {
                bufferInfo.removeElementAt(0);
            }
            System.out.println(text);
            if (infoComponent != null) {
                String s = "";
                for (int i = 0; i < bufferInfo.size(); i++) {
                    s = bufferInfo.elementAt(i) + "\n" + s;
                }
                try{
                    infoComponent.setText(s);
                } catch(Error e){
                    // Arrive quand une actualisation graphique est en cours
                    //e.printStackTrace();
                }
            }
        }
    }

    private final static Object lockErreur = new Object();
    public static void printErreur(String text) {
        synchronized (lockErreur) { // Différents Threads essaieront d'écrire en même temps
            bufferErreurs.addElement(text);
            while (bufferErreurs.size() > tailleBuffer) {
                bufferErreurs.removeElementAt(0);
            }
            System.err.println(text);
            if (erreurComponent != null) {
                String s = "";
                for (int i = 0; i < bufferErreurs.size(); i++) {
                    s = bufferErreurs.elementAt(i) + "\n" + s;
                }
                try{
                    erreurComponent.setText(s);
                } catch(Error e){
                    // Arrive quand une actualisation graphique est en cours
                    //e.printStackTrace();
                }
            }
        }
    }

    public static void setBufferSize(int size){
        tailleBuffer = size;
    }

    public static void setInfoComponent(JTextArea comp){
        infoComponent = comp;
        flushInfo();
    }

    public static void flushInfo(){
        bufferInfo.removeAllElements();
        if(infoComponent!=null){
            infoComponent.setText("");
        }
    }

    public static void setErreurComponent(JTextArea comp){
        erreurComponent = comp;
        flushErreurs();
    }

    public static void flushErreurs(){
        bufferErreurs.removeAllElements();
        if(erreurComponent!=null){
            erreurComponent.setText("");
        }
    }
}
